using System;
using System.Security;
using System.Security.Principal;
using System.Security.AccessControl;
using System.IO;
using System.Collections.Generic;
using System.Text;

namespace DirManip
{
   class Program
   {
      static void Main(string[] args)
      {
         if (File.Exists("cytat.txt"))
         {
            if (!Directory.Exists("katalog"))
            {
               Directory.CreateDirectory("katalog");
            }
            FileInfo f = new FileInfo("cytat.txt");
            if (!File.Exists(@"katalog\cytat.txt"))
               f.CopyTo(@"katalog\cytat.txt");
            Console.WriteLine("Plik: " + f.FullName);
            Console.WriteLine("Lokacja: " + f.Directory.FullName);
            Console.WriteLine("Utworzony: " + f.CreationTime.ToShortDateString());

            FileSecurity fs = f.GetAccessControl();
            Console.WriteLine("Waciciel: {0}", fs.GetOwner(typeof(NTAccount)));
            AuthorizationRuleCollection arc =
               fs.GetAccessRules(true, true, typeof(NTAccount));
            foreach (FileSystemAccessRule ar in arc)
            {
               Console.WriteLine(ar.ToString());
               Console.WriteLine("Uytkownik: {0}", ar.IdentityReference);
               Console.WriteLine("Typ: {0}", ar.AccessControlType);
            }
            Console.ReadLine();
         }
      }
   }
}
